/** @file   predatorai.h
 * @brief   Declaration of PredatorAI class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef PREDATORAI_H
#define PREDATORAI_H

#include "carnivoreai.h"

namespace WeWantWar {

/** @class  PredatorAI
 * @brief   As CarnivoreAI but some variables have different values.
 * @author  Tomi Lamminsaari
 *
 * Mainly this AIController operates as CarnivoreAI but some attributes
 * like attacking distance and visual range have different values. The
 * actual logic is the same so we don't need to implement the <code>
 * update() </code> - method here.
 */
class PredatorAI : public CarnivoreAI
{
public:
  /** Constructor.
   */
  PredatorAI( GameObject* pAlien );
  
  /** Destructor.
   */
  virtual ~PredatorAI();
};

};  // end of namespace

#endif // PREDATORAI_H

/**
 * Version history
 * ===============
 * $Log: predatorai.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:10+02  lamminsa
 * Initial revision
 *
 */
 
